<?php
// Chave da API do TMDb
$apiKey = 'fa7074ec2baf5221068f0d0b684f8698';

// Arquivo de cache local
$cache_file = __DIR__ . '/cache/painel.json';
$cache_time = 3600; // Tempo de validade do cache em segundos

// Função para buscar dados da API
function fetchFromTmdb($url) {
    $res = file_get_contents($url);
    return json_decode($res, true);
}

// Função para converter minutos em formato "xh ym"
function minutosParaHoras($minutos) {
    if (!$minutos) return '';
    $h = floor($minutos / 60);
    $m = $minutos % 60;
    return ($h ? "{$h}h " : "") . ($m ? "{$m}m" : "");
}

// Verifica se o cache está válido
if (file_exists($cache_file) && time() - filemtime($cache_file) < $cache_time) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Busca filmes e séries populares
    $movies = fetchFromTmdb("https://api.themoviedb.org/3/movie/popular?api_key=$apiKey&language=pt-BR&page=1");
    $series = fetchFromTmdb("https://api.themoviedb.org/3/tv/popular?api_key=$apiKey&language=pt-BR&page=1");

    $items = [];
    $max = min(count($movies['results']), count($series['results']));

    // Alterna entre filme e série
    for ($i = 0; $i < $max; $i++) {
        $m = $movies['results'][$i];
        $s = $series['results'][$i];

        // Adiciona filme
        if ($m['poster_path'] && $m['backdrop_path']) {
            $details = fetchFromTmdb("https://api.themoviedb.org/3/movie/{$m['id']}?api_key=$apiKey&language=pt-BR");
            $generos = implode(', ', array_column($details['genres'], 'name'));
            $items[] = [
                'tipo' => 'filme',
                'titulo' => $m['title'],
                'ano' => substr($m['release_date'], 0, 4),
                'generos' => $generos,
                'duracao' => minutosParaHoras($details['runtime']),
                'avaliacao' => round($m['vote_average'], 1),
                'banner' => "https://image.tmdb.org/t/p/original{$m['backdrop_path']}"
            ];
        }

        // Adiciona série
        if ($s['poster_path'] && $s['backdrop_path']) {
            $details = fetchFromTmdb("https://api.themoviedb.org/3/tv/{$s['id']}?api_key=$apiKey&language=pt-BR");
            $generos = implode(', ', array_column($details['genres'], 'name'));
            $items[] = [
                'tipo' => 'serie',
                'titulo' => $s['name'],
                'ano' => substr($s['first_air_date'], 0, 4),
                'generos' => $generos,
                'duracao' => minutosParaHoras($details['episode_run_time'][0] ?? 0),
                'avaliacao' => round($s['vote_average'], 1),
                'banner' => "https://image.tmdb.org/t/p/original{$s['backdrop_path']}"
            ];
        }
    }

    // Salva dados em cache
    file_put_contents($cache_file, json_encode($items));
    $data = $items;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Painel</title>
<style>
body {
    margin: 0;
    padding: 0;
    height: 100vh;
    background-color: #000;
    background-size: cover;
    background-position: center;
    color: white;
    font-family: Arial, sans-serif;
    overflow: hidden;
    transition: background-image 0.8s ease-in-out;
}
.overlay {
    position: absolute;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: linear-gradient(to right, rgba(0,0,0,0.8), transparent);
}
.info {
    position: absolute;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
    z-index: 10;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 1vh;
}

/* Telas grandes: desloca 2.5cm para baixo */
@media (min-width: 868px) {
    .info {
        top: calc(50% + 2.5cm);
    }
}

/* Telas mobile: centraliza verticalmente */
@media (max-width: 867px) {
    .info {
        top: 60%;
        transform: translate(-50%, -50%);
    }
}

.info h1 {
    font-size: 3vw;
    margin: 0;
    font-weight: bold;
    color: white;
    white-space: nowrap;
    text-shadow: 3px 3px 8px rgba(0, 0, 0, 0.8);
}
.info p {
    font-size: 1.5vw;
    margin: 0;
    color: white;
    text-shadow: 2px 2px 6px rgba(0, 0, 0, 0.7);
}
.badge {
    display: inline-block;
    padding: 0.4vw 1vw;
    border-radius: 0.5vw;
    font-size: 1.2vw;
    font-weight: bold;
    color: white;
    margin-bottom: 1vh;
}
.badge.filme {
    background-color: #800080;
}
.badge.serie {
    background-color: #007BFF;
}
</style>
</head>
<body>
<div class="overlay"></div>
<div class="info">
    <div id="badge" class="badge"></div>
    <h1 id="titulo"></h1>
    <p id="meta"></p>
</div>

<script>
let data = <?php echo json_encode($data, JSON_UNESCAPED_UNICODE); ?>;
let index = 0;

function atualizarPainel() {
    let item = data[index];
    document.body.style.backgroundImage = `url('${item.banner}')`;
    document.getElementById('titulo').textContent = `${item.titulo} (${item.ano})`;
    document.getElementById('meta').textContent = `${item.tipo.toUpperCase()} | ${item.generos} | ${item.duracao} | ⭐ ${item.avaliacao}/10`;

    let badge = document.getElementById('badge');
    badge.textContent = item.tipo === 'filme' ? 'FILME' : 'SÉRIE';
    badge.className = item.tipo === 'filme' ? 'badge filme' : 'badge serie';

    index = (index + 1) % data.length;
}

atualizarPainel();
setInterval(atualizarPainel, 12000);
</script>
</body>
</html>








