<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include('includes/header.php');

/* ===============================
   DB
================================ */
$db = new SQLite3('./a/.eggziedb.db');
$db->busyTimeout(10000);

/* ===============================
   LOG TABLE
================================ */
$db->exec("
CREATE TABLE IF NOT EXISTS ibo_change_log (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    changed_at TEXT,
    user TEXT,
    from_data TEXT,
    to_data TEXT,
    affected_ids TEXT,
    total INTEGER
)
");

/* ===============================
   BUSCA + PAGINAÇÃO
================================ */
$q = trim($_GET['q'] ?? '');
$autoFrom = $q;

$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 100; // número de registros exibidos por página
$offset = ($page - 1) * $perPage;

/* ignora /get */
$where = "url NOT LIKE '%/get%'";
$params = [];

if ($q !== '') {
    $where .= " AND (
        url LIKE :q
        OR username LIKE :q
        OR title LIKE :q
        OR mac_address LIKE :q
    )";
    $params[':q'] = "%$q%";
}

/* ===============================
   TOTAL
================================ */
$stCount = $db->prepare("SELECT COUNT(*) total FROM ibo WHERE $where");
foreach ($params as $k => $v) $stCount->bindValue($k, $v);
$total = $stCount->execute()->fetchArray(SQLITE3_ASSOC)['total'];
$totalPages = ceil($total / $perPage);

/* ===============================
   LISTAGEM
================================ */
$st = $db->prepare("
    SELECT id, mac_address, username, title, url
    FROM ibo
    WHERE $where
    ORDER BY id DESC
    LIMIT :limit OFFSET :offset
");
foreach ($params as $k => $v) $st->bindValue($k, $v);
$st->bindValue(':limit', $perPage, SQLITE3_INTEGER);
$st->bindValue(':offset', $offset, SQLITE3_INTEGER);
$list = $st->execute();

/* ===============================
   PERSISTÊNCIA DOS CAMPOS
================================ */
$fromPersist = $_POST['from_data'] ?? $autoFrom;
$toPersist   = $_POST['to_data']   ?? '';

/* ===============================
   PREVIEW
================================ */
$preview = [];
$previewCount = 0;

if (isset($_POST['preview'])) {
    $from = trim($fromPersist);
    $to   = trim($toPersist);

    $p = $db->prepare("
        SELECT id, url, REPLACE(url, :from, :to) new_url
        FROM ibo
        WHERE $where AND url LIKE :fromLike
        LIMIT 50
    ");
    foreach ($params as $k => $v) $p->bindValue($k, $v);
    $p->bindValue(':from', $from);
    $p->bindValue(':to', $to);
    $p->bindValue(':fromLike', "%$from%");
    $res = $p->execute();

    while ($r = $res->fetchArray(SQLITE3_ASSOC)) {
        if ($r['url'] !== $r['new_url']) {
            $preview[] = $r;
            $previewCount++;
        }
    }
}

/* ===============================
   APLICAR
================================ */
$flash = '';

if (isset($_POST['apply'])) {
    $from = $fromPersist;
    $to   = $toPersist;
    $scope = $_POST['scope'] ?? 'selected';
    $idsSel = $_POST['ids'] ?? [];

    $ids = [];
    $sqlIds = "SELECT id FROM ibo WHERE $where AND url LIKE :fromLike";

    if ($scope === 'selected' && $idsSel) {
        $sqlIds .= " AND id IN (" . implode(',', array_map('intval', $idsSel)) . ")";
    }

    $idsSt = $db->prepare($sqlIds);
    foreach ($params as $k => $v) $idsSt->bindValue($k, $v);
    $idsSt->bindValue(':fromLike', "%$from%");
    $resIds = $idsSt->execute();

    while ($r = $resIds->fetchArray(SQLITE3_ASSOC)) $ids[] = $r['id'];

    if ($ids) {
        $db->exec("
            UPDATE ibo
            SET url = REPLACE(url, '$from', '$to')
            WHERE id IN (" . implode(',', $ids) . ")
        ");

        $totalChanged = $db->changes();

        $db->exec("
            INSERT INTO ibo_change_log
            (changed_at, user, from_data, to_data, affected_ids, total)
            VALUES (
                datetime('now'),
                '".($_SESSION['name'] ?? 'system')."',
                '$from',
                '$to',
                '".implode(',', $ids)."',
                $totalChanged
            )
        ");

        $flash = "<div class='alert alert-success'>
            Alteração aplicada em <b>$totalChanged</b> registros.
        </div>";
    }
}

/* ===============================
   DESFAZER
================================ */
if (isset($_POST['undo'])) {
    $last = $db->query("
        SELECT * FROM ibo_change_log
        ORDER BY id DESC LIMIT 1
    ")->fetchArray(SQLITE3_ASSOC);

    if ($last) {
        $db->exec("
            UPDATE ibo
            SET url = REPLACE(url, '{$last['to_data']}', '{$last['from_data']}')
            WHERE id IN ({$last['affected_ids']})
        ");

        $db->exec("DELETE FROM ibo_change_log WHERE id = {$last['id']}");

        $flash = "<div class='alert alert-warning'>
            Última troca desfeita (<b>{$last['total']}</b> registros).
        </div>";
    }
}
?>

<div class="container-fluid px-4">
<h2 class="mt-4 mb-3">Troca em massa (com Preview, Undo e Log)</h2>

<?= $flash ?>

<form method="get" class="form-inline mb-3">
<div class="input-group">
    <input class="form-control" name="q" value="<?= htmlspecialchars($q) ?>"
           placeholder="Buscar DNS, usuário, MAC, nome">
    <div class="input-group-append">
        <button class="btn btn-primary">Buscar</button>
    </div>
</div>
</form>

<form method="post" id="massForm">

<div class="form-row">
<div class="form-group col-md-4">
<label>Dado antigo *</label>
<input class="form-control" name="from_data"
       value="<?= htmlspecialchars($fromPersist) ?>" required>
</div>

<div class="form-group col-md-4">
<label>Dado novo *</label>
<input class="form-control" name="to_data"
       value="<?= htmlspecialchars($toPersist) ?>" required>
</div>

<div class="form-group col-md-4">
<label>Escopo</label>
<select class="form-control" name="scope">
    <option value="selected">Selecionados</option>
    <option value="all">Todos os filtrados</option>
</select>
</div>
</div>

<button type="submit" class="btn btn-info mr-2" name="preview">Preview</button>

<button type="button" class="btn btn-warning mr-2"
        onclick="confirmApply(<?= $previewCount ?: $total ?>)">
    Aplicar
</button>

<button type="button" class="btn btn-danger"
        onclick="confirmUndo()">
    Desfazer última troca
</button>

<hr>

<div class="custom-control custom-checkbox mb-2">
<input type="checkbox" id="checkAll" class="custom-control-input">
<label class="custom-control-label" for="checkAll">Selecionar todos</label>
</div>

<div class="table-responsive">
<table class="table table-striped table-sm">
<thead class="thead-dark">
<tr>
<th></th><th>ID</th><th>MAC</th><th>Usuário</th><th>Nome</th><th>URL</th>
</tr>
</thead>
<tbody>
<?php while ($r = $list->fetchArray(SQLITE3_ASSOC)): ?>
<tr>
<td><input type="checkbox" class="rowcheck" name="ids[]" value="<?= $r['id'] ?>"></td>
<td><?= $r['id'] ?></td>
<td><?= htmlspecialchars($r['mac_address']) ?></td>
<td><?= htmlspecialchars($r['username']) ?></td>
<td><?= htmlspecialchars($r['title']) ?></td>
<td class="small url-cell"><?= htmlspecialchars($r['url']) ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>
</form>

<?php if ($preview): ?>
<hr>
<h5>Preview (até 50 registros)</h5>
<table class="table table-bordered table-sm">
<tr><th>ID</th><th>Atual</th><th>Novo</th></tr>
<?php foreach ($preview as $p): ?>
<tr>
<td><?= $p['id'] ?></td>
<td class="small"><?= htmlspecialchars($p['url']) ?></td>
<td class="small text-success"><?= htmlspecialchars($p['new_url']) ?></td>
</tr>
<?php endforeach; ?>
</table>
<?php endif; ?>

<nav>
<ul class="pagination">
<?php for ($i=1;$i<=$totalPages;$i++): ?>
<li class="page-item <?= $i==$page?'active':'' ?>">
<a class="page-link" href="?q=<?= urlencode($q) ?>&page=<?= $i ?>">
<?= $i ?>
</a>
</li>
<?php endfor; ?>
</ul>
</nav>
</div>

<!-- MODAL PADRÃO -->
<div class="modal fade" id="confirmModal">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header bg-purple text-white">
<h5 class="modal-title" id="confirmTitle"></h5>
<button type="button" class="close text-white" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body text-center">
<p id="confirmMessage"></p>
<p id="confirmImpact" class="text-danger font-weight-bold"></p>
</div>
<div class="modal-footer justify-content-center">
<button class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
<button class="btn" id="confirmBtn">Confirmar</button>
</div>
</div>
</div>
</div>

<style>.bg-purple{background:#6f2cff}</style>

<script>
let actionName = '';

function openModal(title,msg,impact,cls,action){
    document.getElementById('confirmTitle').innerText = title;
    document.getElementById('confirmMessage').innerText = msg;
    document.getElementById('confirmImpact').innerText = impact;
    const b = document.getElementById('confirmBtn');
    b.className = 'btn '+cls;
    actionName = action;
    $('#confirmModal').modal('show');
}

document.getElementById('confirmBtn').onclick = () => {
    const f = document.getElementById('massForm');
    const i = document.createElement('input');
    i.type='hidden'; i.name=actionName; i.value='1';
    f.appendChild(i); f.submit();
};

function confirmApply(total){
    openModal(
        'Confirmar troca',
        'Deseja realmente aplicar a troca?',
        total+' registros serão alterados.',
        'btn-warning',
        'apply'
    );
}

function confirmUndo(){
    openModal(
        'Desfazer última troca',
        'Deseja realmente desfazer a última troca?',
        'Essa ação não poderá ser desfeita.',
        'btn-danger',
        'undo'
    );
}

/* selecionar todos */
document.getElementById('checkAll').onchange = e =>
    document.querySelectorAll('.rowcheck').forEach(c=>c.checked=e.target.checked);

/* auto preencher */
document.querySelectorAll('.rowcheck').forEach(cb=>{
    cb.onchange=()=>cb.checked &&
        (document.querySelector('[name="from_data"]').value =
         cb.closest('tr').querySelector('.url-cell').innerText.trim());
});
</script>

<?php include('includes/footer.php'); ?>
