<?php

function syncDnsJsonFromDB() {

    $db = new SQLite3('a/.eggziedb.db');
    $file = __DIR__ . '/../dns_listas.json';

    $dnsMap = [];

    $res = $db->query("SELECT DISTINCT url FROM ibo WHERE url IS NOT NULL AND url != ''");

    while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
        $url = trim($row['url']);
        if ($url === '') continue;

        // regra: 1 DNS = 1 lista
        $dnsMap[$url] = [$url];
    }

    file_put_contents(
        $file,
        json_encode(
            $dnsMap,
            JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE
        )
    );
}


