<?php
declare(strict_types=1);
session_start();

// Se já logado, ir direto para o painel:
$PAINEL = 'users.php'; // troque para 'gerador.php' se preferir
if (isset($_SESSION['id'])) {
  header("Location: {$PAINEL}");
  exit;
}

// FIXOS (editáveis aqui mesmo)
$BRAND    = 'P2PLAY APPS';
$SUBTITLE = 'Seu melhor app!';

// LOGO: puxa do mesmo banco do login
$LOGO = 'img/logo.png';
try {
  if (is_file('./a/.eggziepanels.db')) {
    $db  = new SQLite3('./a/.eggziepanels.db');
    $row = $db->query('SELECT LOGO FROM USERS WHERE id=1')->fetchArray(SQLITE3_ASSOC);
    if ($row && !empty($row['LOGO'])) {
      $LOGO = $row['LOGO'];
    }
  }
} catch (Throwable $e) { /* segue com fallback */ }
?>
<!doctype html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>IBO 3.8 — <?= htmlspecialchars($BRAND) ?></title>

  <!-- Favicons (coloque os arquivos em /img) -->
  <link rel="apple-touch-icon" sizes="180x180" href="img/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="img/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="img/favicon-16x16.png">
  <link rel="manifest" href="img/site.webmanifest">
  <meta name="theme-color" content="#0b0b0e">

  <!-- Bootstrap + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    :root{
      --glass:#11151fA6; --stroke:#ffffff22; --text:#e8eef5; --muted:#b7c6d8;
      --cta1:#7c3aed; --cta2:#06b6d4; --bg:#0b0b0e;
      --shadow:0 20px 50px rgba(0,0,0,.45), inset 0 1px 0 rgba(255,255,255,.04);
    }
    html,body{height:100%}
    body{
      margin:0;
      background:
        radial-gradient(1100px 700px at 12% -10%, rgba(124,58,237,.25), transparent 60%),
        radial-gradient(1100px 700px at 110% 110%, rgba(6,182,212,.22), transparent 60%),
        var(--bg);
      color:var(--text); overflow:hidden;
      font-family: system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
    }
    .bg-canvas{position:fixed; inset:0; width:100vw; height:100vh; z-index:0; pointer-events:none; opacity:.55}

    .wrap{position:relative; z-index:1; display:flex; align-items:center; justify-content:center; min-height:100vh; padding:24px}
    .card-glass{
      width:min(760px, 74vw);
      background: linear-gradient(180deg, var(--glass), rgba(17,21,31,.66));
      backdrop-filter: blur(16px); -webkit-backdrop-filter: blur(16px);
      border:1px solid var(--stroke); box-shadow: var(--shadow);
      border-radius:24px; padding: clamp(24px, 4vw, 48px);
    }
    /* Em telas grandes, deixe o card com metade da largura */
@media (min-width: 900px){
  .card-glass{
    width: 35vw;     /* 50% da largura da janela */
    max-width: none; /* permite passar de 960px em monitores maiores */
  }
}
    .logo-wrap{
      width:110px; height:110px; border-radius:20px; margin:0 auto 18px;
      background:#0a0a0a; display:grid; place-items:center;
      border:1px solid rgba(255,255,255,.08);
      box-shadow: inset 0 6px 24px rgba(255,255,255,.06), inset 0 -8px 30px rgba(0,0,0,.25);
    }
    .logo-wrap img{width:74px; height:74px; object-fit:contain; filter: drop-shadow(0 6px 14px rgba(0,0,0,.35))}

    .title{
      font-weight:900; font-size: clamp(30px, 4.5vw, 48px);
      letter-spacing:.3px; text-align:center; margin:4px 0 6px;
      background: linear-gradient(135deg,var(--cta1),var(--cta2));
      -webkit-background-clip:text; background-clip:text; color:transparent;
    }
    .subtitle{color:#bcd2ea; text-align:center; margin-bottom:10px; font-weight:700}

    /* Marquee */
    .marquee-wrap{
      overflow:hidden; border-radius:12px; border:1px solid rgba(255,255,255,.06);
      background:#0e1220aa; margin: 8px auto 24px; max-width:820px;
    }
    .marquee{
      display:inline-block; white-space:nowrap; padding:10px 0;
      animation: scroll-x 18s linear infinite;
    }
    .marquee span{
      display:inline-flex; align-items:center; gap:6px; margin:0 18px; color:#cfe6ff;
      font-weight:600;
    }
    .marquee i{opacity:.85}
    @keyframes scroll-x{ 0%{transform:translateX(0)} 100%{transform:translateX(-50%)} }
    @media (prefers-reduced-motion: reduce){ .marquee{ animation:none } }

    .btn-cta{
      display:inline-flex; align-items:center; gap:.5rem; justify-content:center;
      background: linear-gradient(90deg, var(--cta1), var(--cta2));
      color:#eef6ff; font-weight:800; letter-spacing:.3px;
      border:none; border-radius:999px; padding:14px 26px;
      box-shadow: 0 10px 25px rgba(6,182,212,.35);
      transition:.15s transform ease, .15s filter ease;
    }
    .btn-cta:hover{transform: translateY(-1px); filter: brightness(1.05)}

    .mini{color:#9fb3c8; font-size:.95rem; text-align:center; margin-top:16px}
  </style>
</head>
<body>
  <!-- Partículas -->
  <canvas id="bgParticles" class="bg-canvas"></canvas>

  <div class="wrap">
    <div class="card-glass text-center">
      <div class="logo-wrap">
        <img src="<?= htmlspecialchars($LOGO) ?>" alt="Logo">
      </div>

      <div class="title">IBO 3.8</div>
      <div class="subtitle"><?= htmlspecialchars($SUBTITLE) ?></div>

      <!-- Marquee -->
      <div class="marquee-wrap">
        <div class="marquee" aria-label="Informações em destaque (rolando)">
          <span><i class="bi bi-check2-circle"></i> Teste Automático</span>
          <span><i class="bi bi-magic"></i> Baneres automáticos</span>
          <span><i class="bi bi-diagram-3"></i> Troca de DNS em massa</span>

          <!-- repete p/ loop contínuo -->
          <span><i class="bi bi-check2-circle"></i> Teste Automático</span>
          <span><i class="bi bi-magic"></i> Baneres automáticos</span>
          <span><i class="bi bi-diagram-3"></i> Troca de DNS em massa</span>
        </div>
      </div>

      <a href="login.php" class="btn-cta">
        <i class="bi bi-box-arrow-in-right"></i> INICIAR SESSÃO
      </a>

      <div class="mini">© <?= date('Y') ?> P2PLAY APPS — Todos os direitos reservados.</div>
    </div>
  </div>

  <!-- libs & partículas -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/tsparticles-engine"></script>
  <script src="https://cdn.jsdelivr.net/npm/tsparticles-interaction-external-repulse"></script>
  <script src="https://cdn.jsdelivr.net/npm/tsparticles-shape-circle"></script>
  <script src="https://cdn.jsdelivr.net/npm/tsparticles-slim"></script>
  <script>
    (async () => {
      const { tsParticles } = window;
      await tsParticles.load("bgParticles", {
        fullScreen: { enable: false },
        background: { color: { value: "transparent" } },
        fpsLimit: 60,
        particles: {
          number: { value: 85, density: { enable: true, area: 900 } },
          color: { value: ["#6ee7ff","#8b5cf6","#ffffff"] },
          links: { enable: true, distance: 120, opacity: 0.28, width: 1, color: "#9fb3ff" },
          move: { enable: true, speed: 0.8 },
          size: { value: { min: 1, max: 2.4 } },
          opacity: { value: 0.85 }
        },
        interactivity: {
          events: { onHover: { enable: true, mode: "repulse" }, resize: true },
          modes: { repulse: { distance: 140, duration: 0.3 } }
        }
      });
    })();
  </script>
</body>
</html>

