<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* ======================
   DB
====================== */
$db1 = new SQLite3('a/.eggziedb.db');

/* ======================
   DNS LISTAS (JSON)
====================== */
function loadDnsListas() {
    $file = 'dns_listas.json';
    if (!file_exists($file)) return [];
    return json_decode(file_get_contents($file), true) ?: [];
}
$dnsListas = loadDnsListas();

/* ======================
   MAC PROPRIEDADE (JSON)
====================== */
function loadMacProps() {
    $file = 'mac_propriedade.json';
    if (!file_exists($file)) return [];
    return json_decode(file_get_contents($file), true) ?: [];
}
$macProps = loadMacProps();

/* ======================
   DELETE MÚLTIPLO
====================== */
$msg = '';
$msg_type = '';

if (!empty($_POST['delete_ids']) && is_array($_POST['delete_ids'])) {

    $ids = array_map('intval', $_POST['delete_ids']);
    $total = count($ids);

    if ($total > 0) {
        $placeholders = implode(',', $ids);
        if ($db1->exec("DELETE FROM ibo WHERE id IN ($placeholders)")) {
            $msg = "$total usuário(s) apagado(s) com sucesso!";
            $msg_type = 'success';
        } else {
            $msg = 'Erro ao apagar usuários!';
            $msg_type = 'danger';
        }
    }
}

$res1 = $db1->query("SELECT * FROM ibo ORDER BY id ASC");

include 'includes/header.php';
?>

<link rel="stylesheet" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<style>
.text-short{
    max-width:220px;
    white-space:nowrap;
    overflow:hidden;
    text-overflow:ellipsis;
}
.actions-nowrap{ white-space:nowrap; }
td:first-child{ text-align:center; }

.table-responsive-custom{
    width:100%;
    overflow-x:auto;
    -webkit-overflow-scrolling:touch;
}
.table-responsive-custom::-webkit-scrollbar{ height:8px; }
.table-responsive-custom::-webkit-scrollbar-thumb{
    background:#bbb;
    border-radius:10px;
}

@media (max-width:768px){
    .btn{ width:100%; margin-bottom:8px; }
    .actions-nowrap a{ display:block; margin-bottom:5px; }
}
</style>

<!-- MODAL CONFIRMAÇÃO -->
<div class="modal fade" id="confirmDeleteModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">IBO 3.8 | P2PLAY APPS</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body text-center">
        <p>Deseja realmente apagar os usuários selecionados?</p>
        <p class="text-danger font-weight-bold" id="deleteCount"></p>
      </div>
      <div class="modal-footer justify-content-center">
        <button class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        <button class="btn btn-danger" id="confirmDeleteBtn">
          <i class="fa fa-trash"></i> Apagar
        </button>
      </div>
    </div>
  </div>
</div>

<main class="container-fluid mt-4">

<?php if ($msg) { ?>
<div class="alert alert-<?= $msg_type ?> alert-dismissible fade show">
  <?= $msg ?>
  <button class="close" data-dismiss="alert">&times;</button>
</div>
<?php } ?>

<div class="card shadow">
  <div class="card-header text-primary font-weight-bold">Usuários</div>
  <div class="card-body">

    <a href="users_create.php" class="btn btn-primary mb-3">
      <i class="fa fa-plus"></i> Adicionar Cliente
    </a>

    <div class="form-group mb-3">
      <input type="text" id="smartSearch" class="form-control"
             placeholder="Buscar por Cliente, MAC, Usuário ou URL...">
    </div>

    <div class="mb-3">
      <button type="button" id="btnSelectAll" class="btn btn-secondary">
        <i class="fa fa-check-square-o"></i> Selecionar Todos
      </button>

      <button type="button" id="btnDeleteSelected" class="btn btn-danger ml-2">
        <i class="fa fa-trash"></i> Apagar Selecionados
      </button>
    </div>

    <form method="post" id="deleteForm">

    <div class="table-responsive-custom">
    <table id="myTable" class="table table-striped table-hover">
      <thead class="text-primary">
        <tr>
          <th></th>
          <th>Nome Servidor</th>
          <th>MAC</th>
          <th>Proprietário do MAC</th>
          <th>Usuário</th>
          <th>Expira</th>
          <th>Endereço DNS</th>
          <th>Ações</th>
        </tr>
      </thead>
      <tbody>

      <?php while ($row = $res1->fetchArray(SQLITE3_ASSOC)) {

          // Resolve DNS via lista
          $urlRaw = $row['url'];
          $urlFinal = $dnsListas[$urlRaw] ?? $urlRaw;
      ?>
        <tr>
          <td>
            <input type="checkbox" name="delete_ids[]" value="<?= $row['id'] ?>">
          </td>

          <td class="text-short" title="<?= htmlspecialchars($row['title']) ?>">
            <?= htmlspecialchars($row['title']) ?>
          </td>

          <td><?= htmlspecialchars($row['mac_address']) ?></td>

          <td>
            <?= htmlspecialchars($macProps[strtoupper($row['mac_address'])] ?? '-') ?>
          </td>

          <td><?= htmlspecialchars($row['username']) ?></td>
          <td><?= htmlspecialchars($row['expire_date']) ?></td>

          <td class="text-short" title="<?= htmlspecialchars($urlFinal) ?>">
            <?= htmlspecialchars($urlFinal) ?>
          </td>

          <td class="actions-nowrap">
            <a href="users_update.php?update=<?= $row['id'] ?>" class="btn btn-warning btn-sm">
              <i class="fa fa-pencil"></i> Editar
            </a>
            <a href="users.php?delete=<?= $row['id'] ?>"
               class="btn btn-danger btn-sm"
               onclick="return confirm('Deseja apagar este usuário?')">
              <i class="fa fa-trash"></i> Excluir
            </a>
          </td>
        </tr>
      <?php } ?>

      </tbody>
    </table>
    </div>

    </form>

  </div>
</div>
</main>

<script>
$(function(){

  var table = $('#myTable').DataTable({
    pageLength: 100,
    scrollX: true,
    dom: 'rtip',
    language: {
        info: "Mostrando _START_ até _END_ de _TOTAL_ registros",
        infoEmpty: "Mostrando 0 até 0 de 0 registros",
        infoFiltered: "(filtrado de _MAX_ registros no total)",
        emptyTable: "Nenhum registro encontrado",
        zeroRecords: "Nenhum registro corresponde à busca",
        paginate: {
            first: "Primeiro",
            last: "Último",
            next: "Próximo",
            previous: "Anterior"
        }
    }
});

  $('#smartSearch').on('keyup', function(){
    table.search(this.value).draw();
  });

  $('#btnSelectAll').on('click', function(){
    $('input[name="delete_ids[]"]').prop('checked', true);
  });

  $('#btnDeleteSelected').on('click', function(){
    var total = $('input[name="delete_ids[]"]:checked').length;
    if (total === 0) {
      alert('Selecione ao menos um usuário.');
      return;
    }
    $('#deleteCount').text(total + ' usuário(s) serão apagados.');
    $('#confirmDeleteModal').modal('show');
  });

  $('#confirmDeleteBtn').on('click', function(){
    $('#deleteForm').submit();
  });

});
</script>

<?php include 'includes/footer.php'; require 'includes/egz.php'; ?>
