<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* ======================
   DB
====================== */
$db = new SQLite3('./a/.eggziedb.db');
$db->exec('CREATE TABLE IF NOT EXISTS ibo(
    id INTEGER PRIMARY KEY NOT NULL,
    mac_address VARCHAR(100),
    username VARCHAR(100),
    password VARCHAR(100),
    expire_date VARCHAR(100),
    url VARCHAR(100),
    title VARCHAR(100),
    created_at VARCHAR(100)
)');

/* ======================
   MAC PROPRIEDADE JSON
====================== */
function loadMacProps() {
    $file = 'mac_propriedade.json';
    if (!file_exists($file)) return [];
    return json_decode(file_get_contents($file), true) ?: [];
}

function saveMacProp($mac, $obs) {
    if (!$mac || !$obs) return;
    $file = 'mac_propriedade.json';
    $data = loadMacProps();
    $data[strtoupper($mac)] = trim($obs);
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

/* ======================
   DNS → LISTA JSON
====================== */
function loadDnsList() {
    $file = 'dns_listas.json';
    if (!file_exists($file)) return [];
    return json_decode(file_get_contents($file), true) ?: [];
}

function saveDnsList($dns, $title) {
    if (!$dns || !$title) return;

    $file = 'dns_listas.json';
    $data = loadDnsList();

    $dns = preg_replace('#/get\.php.*$#i', '', trim($dns));
    $dns = rtrim($dns, '/');

    if (!isset($data[$dns])) {
        $data[$dns] = trim($title);
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
}

/* ======================
   AJAX BUSCA MAC
====================== */
if (isset($_GET['get_mac_obs'])) {
    $mac = strtoupper($_GET['get_mac_obs']);
    $data = loadMacProps();
    echo json_encode(['obs' => $data[$mac] ?? '']);
    exit;
}

/* ======================
   INSERT
====================== */
if (isset($_POST['submit'])) {

    $we = strtotime($_POST['expire_date']);
    $ne = date('Y-m-d', $we);

    $full = date('Y-m-d') . 'T' . date('H:i:s') . '.000000Z';

    $db->exec("
        INSERT INTO ibo(mac_address, username, password, expire_date, url, title, created_at)
        VALUES(
            '".strtoupper($_POST['mac_address'])."',
            '".$_POST['username']."',
            '".$_POST['password']."',
            '".$ne."',
            '".$_POST['dns']."',
            '".$_POST['title']."',
            '".$full."'
        )
    ");

    saveMacProp($_POST['mac_address'], $_POST['mac_owner']);
    saveDnsList($_POST['dns'], $_POST['title']);

    header('Location: users.php');
    exit;
}

/* ======================
   PLAYLIST RANDOM
====================== */
$playlistNames = [
    'P2PLAY ONLINE',
    'P2PLAY VIP',
    'P2PLAY EXTRA',
    'P2PLAY PLUS',
    'P2PLAY STREAMING',
    'P2PLAY SERVER',
];
$randomPlaylistName = $playlistNames[array_rand($playlistNames)];

include 'includes/header.php';
?>

<!-- JS FORMAT MAC -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    const macInput = document.getElementById("mac_address");
    const macOwner = document.getElementById("mac_owner");

    macInput.addEventListener("input", function(e) {
        let value = e.target.value.replace(/[^A-Fa-f0-9]/g, "").toUpperCase();
        let formatted = "";
        for (let i = 0; i < value.length; i++) {
            formatted += value[i];
            if ((i + 1) % 2 === 0 && i < value.length - 1) formatted += ":";
        }
        e.target.value = formatted;
    });

    macInput.addEventListener("blur", function() {
        if (!this.value) return;
        fetch("users_create.php?get_mac_obs=" + encodeURIComponent(this.value))
            .then(r => r.json())
            .then(d => { if (d.obs) macOwner.value = d.obs; });
    });
});
</script>

<!-- EXTRATOR M3U -->
<script>
function extract(event) {
  event.preventDefault();
  var m3uLink = document.getElementById("m3u_address").value;
  document.getElementById("server_url").value = m3uLink.split("/get.php")[0];
  document.getElementById("username").value = new URL(m3uLink).searchParams.get("username") || "";
  document.getElementById("password").value = new URL(m3uLink).searchParams.get("password") || "";
}
</script>

<!-- FORMULÁRIO (COM LEGENDAS RESTAURADAS) -->
<div class="card shadow mb-4">
<div class="card-header">
    <h6 class="font-weight-bold text-primary">Detalhes do Usuário</h6>
</div>

<div class="card-body">
<form method="post">

<label>Endereço MAC</label>
<input class="form-control mb-2" id="mac_address" name="mac_address" required placeholder="MAC">

<label>Proprietário do MAC</label>
<input class="form-control mb-2" id="mac_owner" name="mac_owner" placeholder="Proprietário do MAC">

<label>Nome</label>
<input class="form-control mb-2" name="title" value="<?= $randomPlaylistName ?>" required placeholder="Nome da Lista">

<label>Lista M3U</label>
<div class="input-group mb-2">
    <input class="form-control" id="m3u_address" required placeholder="M3U">
    <button class="btn btn-success" onclick="extract(event)">Extrair</button>
</div>

<label>DNS</label>
<input class="form-control mb-2" name="dns" id="server_url" required placeholder="DNS">

<label>Username</label>
<input class="form-control mb-2" name="username" id="username" required placeholder="Username">

<label>Password</label>
<input class="form-control mb-2" name="password" id="password" required placeholder="Password">

<label>Data de Expiração</label>
<input class="form-control mb-3" name="expire_date" value="2084-10-14">

<button class="btn btn-success" name="submit">Cadastrar</button>

</form>
</div>
</div>

<?php include 'includes/footer.php'; ?>


